% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/if_else.R
\name{if_else}
\alias{if_else}
\title{Vectorised if}
\usage{
if_else(condition, true, false, missing = NULL)
}
\arguments{
\item{condition}{A \code{logical(n)} vector.}

\item{true, false}{Values to use for \code{TRUE} and \code{FALSE} in \code{condition}. They must either be the same length as
\code{condition} or be length 1. They must also be the same type.}

\item{missing}{If not \code{NULL} (the default), this will replace any missing values.}
}
\value{
A vector the same length as \code{condition} with values for \code{TRUE} and \code{FALSE} replaced by those specified in
\code{true} and \code{false}, respectively.
}
\description{
This is a wrapper around \code{ifelse()} which checks that \code{true} and \code{false} are of the same type, making the output more
predictable.
}
\examples{
x <- c(-5:5, NA)
if_else(x < 0, NA_integer_, x)
if_else(x < 0, "negative", "positive", "missing")

# Unlike ifelse, if_else preserves types
x <- factor(sample(letters[1:5], 10, replace = TRUE))
ifelse(x \%in\% c("a", "b", "c"), x, factor(NA))
# Attributes are taken from the `true` vector
if_else(x \%in\% c("a", "b", "c"), x, factor(NA))

}
