% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_ABC.R
\name{plot_weighted}
\alias{plot_weighted}
\title{Plot the density estimation of a given parameter}
\usage{
plot_weighted(
  prior,
  merged_posterior,
  index,
  limits,
  regWeights = TRUE,
  weighted = TRUE
)
}
\arguments{
\item{prior}{is a vector or matrix of simulated parameter values i.e. numbers
from the simulations. Each row or vector entry should be a different
simulation and each column of a matrix should be a different parameter.
This corresponds to the prior distribution and it should contain all the
simulated parameter values.}

\item{merged_posterior}{is a list obtained by the \code{\link[=mergepost]{mergepost()}} function. The
output of that function produces a list with the locfit of the various
parameters. This function plots those locfits.}

\item{index}{is an non-negative integer indicating which parameter to plot.
It corresponds to the desired entry of the \code{merged_posterior} list. So, to
plot the first parameter, corresponding to the first entry in the
\code{merged_posterior} input select 1. To plot the second parameter, select 2
and so on.}

\item{limits}{is a matrix with two columns and as many rows as there are
parameters. Each row should contain the minimum value of the prior for a
given parameter in the first column and the maximum value in the second
column.}

\item{regWeights}{logical, indicating whether to plot the posterior density
obtained from merging the multiple posteriors with or without the weights
of the regression step. The default is TRUE.}

\item{weighted}{logical, indicating whether to plot the posterior density
obtained from merging the multiple posteriors with or without weighting by
the overall distance to the global mean. The default is TRUE.}
}
\value{
a plot of the density estimation of a given parameter. This plot will
include a title with the name of the parameter. It will also include the
density of the prior distribution for that parameter. The density
estimation shown here is obtained after merging multiple posteriors for
that parameter.
}
\description{
Plots a locfit object obtained after parameter estimation with Approximate
Bayesian Computation using the \code{\link[=multipleABC]{multipleABC()}} function and merging the
multiple posteriors with the \code{\link[=mergepost]{mergepost()}} function.
}
\details{
The \code{\link[=mergepost]{mergepost()}} function includes different posterior merging methods and
produces locfit objects for each parameter and method. It is possible to
select which parameter to plot, with the \code{index} input, and whether to plot
the density estimation after each accepted point was weighted by its
regression weight and by distance of its associated target to the overall
mean of the data. If \code{regWeights} is set to FALSE, the density estimation
obtained without considering the regression weights will be plotted. If
\code{weighted} is set to FALSE, the density estimation obtained without
considering the distance between the mean summary statistics of the target
and the mean across all loci.
}
\examples{
# load the matrix with parameter values
data(params)
# load the matrix with simulated parameter values
data(sumstats)
# load the matrix with the prior limits
data(limits)

# select some random simulations to act as target just to test the function
targets <- sumstats[c(11:20) ,]
# we should remove those random simulation from the sumstats and params matrices
sumstats <- sumstats[-c(11:20), ]; params <- params[-c(11:20), ]

# parameter estimation for multiple targets
myabc <- multipleABC(targets = targets, params = params, sumstats = sumstats, limits = limits,
tol = 0.01, method = "regression")

# select a random simulation to act as the global value of the summary statistics
# ideally this should be computed from the entirety of the observed data
global <- sumstats[50, ]

# merge the posterior distributions obtained in the previous step
mymerge <- mergepost(target = targets, global = global, post = myabc$adjusted,
wtreg = myabc$weights)

# plot the merged posterior distribution
plot_weighted(prior = params, merged_posterior = mymerge, index = 7, limits = limits)

# note that this is just an example!
# we don't have enough simulations to obtain credible results

}
