% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lookup.R
\name{lookup}
\alias{lookup}
\title{Lookup table}
\usage{
lookup(table, t)
}
\arguments{
\item{table}{a \sQuote{covartable} object created by a call to \code{\link{covariate_table}}}

\item{t}{numeric vector; times at which interpolated values of the covariates in \code{table} are required.}
}
\value{
A numeric vector or matrix of the interpolated values.
}
\description{
Interpolate values from a lookup table
}
\section{Extrapolation}{

If \code{t} is outside the range of the lookup table, the values will be extrapolated, and a warning will be issued.
The type of extrapolation performed will be constant or linear according to the \code{order} flag used when creating the table.
}

\seealso{
More on interpolation:
\code{\link{bsplines}},
\code{\link{covariates}}
}
\concept{interpolation}
