% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_partially_observable.R
\name{MDP2POMDP}
\alias{MDP2POMDP}
\alias{make_partially_observable}
\alias{make_fully_observable}
\title{Convert between MDPs and POMDPs}
\usage{
make_partially_observable(x, observations = NULL, observation_prob = NULL)

make_fully_observable(x)
}
\arguments{
\item{x}{a \code{MDP} object.}

\item{observations}{a character vector specifying the names of the available
observations.}

\item{observation_prob}{Specifies the observation probabilities (see \link{POMDP} for details).}
}
\value{
a \code{MDP} or a \code{POMDP} object.
}
\description{
Convert a MDP into POMDP by adding an observation model or
a POMDP into a MDP by making the states observable.
}
\details{
\code{make_partially_observable()} adds an observation model to an MDP. If no observations and
observation probabilities are provided, then an observation for each state is created
with identity observation matrices. This means we have a fully observable model
encoded as a POMDP.

\code{make_fully_observable()} removes the observation model from a POMDP and returns
an MDP.
}
\examples{
# Turn the Maze MDP into a partially observable problem.
# Here each state has an observation, so it is still a fully observable problem
# encoded as a POMDP.
data("Maze")
Maze

Maze_POMDP <- make_partially_observable(Maze)
Maze_POMDP

sol <- solve_POMDP(Maze_POMDP)
policy(sol)
simulate_POMDP(sol, n = 1, horizon = 100, return_trajectories = TRUE)$trajectories

# Make the Tiger POMDP fully observable
data("Tiger")
Tiger

Tiger_MDP <- make_fully_observable(Tiger)
Tiger_MDP

sol <- solve_MDP(Tiger_MDP)
policy(sol)
# The result is not exciting since we can observe where the tiger is!
}
\seealso{
Other MDP: 
\code{\link{MDP}()},
\code{\link{MDP_policy_functions}},
\code{\link{accessors}},
\code{\link{actions}()},
\code{\link{add_policy}()},
\code{\link{gridworld}},
\code{\link{reachable_and_absorbing}},
\code{\link{regret}()},
\code{\link{simulate_MDP}()},
\code{\link{solve_MDP}()},
\code{\link{transition_graph}()},
\code{\link{value_function}()}

Other POMDP: 
\code{\link{POMDP}()},
\code{\link{accessors}},
\code{\link{actions}()},
\code{\link{add_policy}()},
\code{\link{plot_belief_space}()},
\code{\link{projection}()},
\code{\link{reachable_and_absorbing}},
\code{\link{regret}()},
\code{\link{sample_belief_space}()},
\code{\link{simulate_POMDP}()},
\code{\link{solve_POMDP}()},
\code{\link{solve_SARSOP}()},
\code{\link{transition_graph}()},
\code{\link{update_belief}()},
\code{\link{value_function}()},
\code{\link{write_POMDP}()}
}
\author{
Michael Hahsler
}
\concept{MDP}
\concept{POMDP}
