% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cst_deliv_duration.R
\encoding{UTF-8}
\name{cst_deliv_duration}
\alias{cst_deliv_duration}
\title{Constant delivery duration drugs}
\usage{
cst_deliv_duration(
  Rx_deliv,
  Rx_drug_code,
  Rx_deliv_dur,
  Cst_deliv_dur,
  Cst_drug_code,
  Cst_duration
)
}
\arguments{
\item{Rx_deliv}{Name of the table listing all prescription drugs delivered.}

\item{Rx_drug_code}{Column name of \code{Rx_deliv} that contains the drug unique identifier.}

\item{Rx_deliv_dur}{Column name of the constant treatment duration in the \code{Rx_deliv} table.}

\item{Cst_deliv_dur}{Name of the table that contains the constant delivery durations that will overwrite that in the \code{Rx_deliv} table for the specified drug codes.}

\item{Cst_drug_code}{Column name of \code{Cst_deliv_dur} that contains the drug unique identifier (same format as \code{Rx_drug_code}).}

\item{Cst_duration}{Column name of the constant treatment duration in the \code{Cst_deliv_dur} table (same format as \code{Rx_deliv_dur}).}
}
\value{
\code{data.table} of the same structure as \code{Rx_deliv}.
}
\description{
Overwrites the recorded delivery durations of specific drugs with constant durations as specified in a user-provided table.
}
\examples{
# With matches
rx1 <- data.frame(id = c(1, 1, 2, 2, 2), code = c("A", "B", "B", "C", "D"),
                  duration = as.integer(c(30, 15, 15, 7, 90)))
cst1 <- data.frame(CODES = c("B", "D"), DURATION = as.integer(c(45, 60)))
cst_deliv_duration(
  Rx_deliv = rx1, Rx_drug_code = "code", Rx_deliv_dur = "duration",
  Cst_deliv_dur = cst1, Cst_drug_code = "CODES", Cst_duration = "DURATION"
)

# No matches
rx2 <- data.frame(id = c(1, 1, 2, 2, 2), code = c("A", "B", "B", "C", "D"),
                  duration = as.integer(c(30, 15, 15, 7, 90)))
cst2 <- data.frame(CODES = c("E", "F"), DURATION = as.integer(c(45, 60)))
cst_deliv_duration(
  Rx_deliv = rx2, Rx_drug_code = "code", Rx_deliv_dur = "duration",
  Cst_deliv_dur = cst2, Cst_drug_code = "CODES", Cst_duration = "DURATION"
)
}
