% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poi_multi.R
\name{poi_multi}
\alias{poi_multi}
\title{Pole of Inaccessibility for Multi-Polygons}
\usage{
poi_multi(polygons, ...)
}
\arguments{
\item{polygons}{a list, each element containing
entries \code{x} and \code{y}. See \code{\link[=poi]{poi()}} for details
about what these need to be.}

\item{...}{
  Arguments passed on to \code{\link[=poi]{poi}}
  \describe{
    \item{\code{x}}{a vector of x coordinates or a matrix or data.frame
of x and y coordinates, a list of components x and y,
a time series (see \code{\link[grDevices:xy.coords]{grDevices::xy.coords()}} for details),
or a simple features object from package \code{sf}.}
    \item{\code{y}}{a vector of y coordinates. Only needs to be provided if
\code{x} is vector.}
    \item{\code{precision}}{the precision to use when computing the center}
  }}
}
\value{
A list with items
\item{\code{x}}{x coordinate of the center}
\item{\code{y}}{y coordinate of the center}
\item{\code{dist}}{distance to the enclosing polygon}
}
\description{
This function is a convenience function to be used with
multi-polygons (lists of polygons). The function
simply calls \code{\link[=poi]{poi()}} for each polygon in the list
and returns the point wit the maximum distance to
the boundaries of the enclosing polygon.
}
\examples{
p1 <- rbind(
  c(0, 0),
  c(1, 0),
  c(3, 2),
  c(2, 4),
  c(1, 4),
  c(0, 0),
  c(NA, NA),
  c(1, 1),
  c(1, 2),
  c(2, 2),
  c(1, 1)
)
p2 <- rbind(
  c(3, 0),
  c(4, 0),
  c(4, 1),
  c(3, 1),
  c(3, 0),
  c(NA, NA),
  c(3.3, 0.8),
  c(3.8, 0.8),
  c(3.8, 0.3),
  c(3.3, 0.3),
  c(3.3, 0.3)
)
p3 <- rbind(
  c(3, 3),
  c(4, 2),
  c(4, 3),
  c(3, 3)
)
mpol <- list(p1, p2, p3)

plot.new()
plot.window(c(0, 4), c(0, 4), asp = 1)
for (i in seq_along(mpol)) {
  polypath(mpol[[i]])
}

res <- poi_multi(mpol, precision = 1e-5)
points(res, pch = 19, col = "steelblue4")

res
}
\seealso{
\code{\link[=poi]{poi()}}
}
