% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/angles.R
\name{hammer_to_sph}
\alias{hammer_to_sph}
\alias{sph_to_hammer}
\title{Map Cartesian coordinates into Hammer projection}
\usage{
sph_to_hammer(x)

hammer_to_sph(y)
}
\arguments{
\item{x}{matrix of size \code{c(n, 3)} with the Cartesian coordinates on
\eqn{\mathcal{S}^2}. Assumed to be of unit norm in the rows.}

\item{y}{matrix of size \code{c(n, 2)} with the Hammer coordinates.}
}
\value{
\itemize{
\item{\code{sph_to_hammer}: the matrix \code{y}.}
\item{\code{hammer_to_sph}: the matrix \code{x}.}
}
}
\description{
Computes the Hammer projection of points on the sphere.
}
\examples{
# Plot Fibonacci lattice
plot(sph_to_hammer(fib_latt(n = 1000)))
points(sph_to_hammer(rbind(c(0, 0, 1), c(0, 0, -1))), col = 2, pch = 19)
points(sph_to_hammer(rbind(c(1, 0, 0), c(-1, 0, 0))), col = 3, pch = 19)
points(sph_to_hammer(rbind(c(0, 1, 0), c(0, -1, 0))), col = 4, pch = 19)

# Check changes of coordinates
hammer_to_sph(sph_to_hammer(rbind(c(1, 0, 0), c(0, 1, 0))))
sph_to_hammer(hammer_to_sph(rbind(c(0, 0), c(0.5, 0.5))))
}
