\name{readTagDigger}
\alias{readTagDigger}
\title{
Import Read Counts from TagDigger
}
\description{
\code{readTagDigger} reads the CSV output containing read counts
from TagDigger and generates a \code{"\link{RADdata}"} object.
Optionally, it can also import a tag database generated by the
Tag Manager program within TagDigger, containing information 
such as alignment position, to be stored in the \code{$locTable}
slot of the \code{"RADdata"} object.
}
\usage{
readTagDigger(countfile, includeLoci = NULL, 
              possiblePloidies = list(2), taxaPloidy = 2L,
              contamRate = 0.001,
              dbfile = NULL, dbColumnsToKeep = NULL, 
              dbChrCol = "Chr", dbPosCol = "Pos", 
              dbNameCol = "Marker name")
}
\arguments{
  \item{countfile}{
Name of the file containing read counts.
}
  \item{includeLoci}{
An optional character vector containing names of loci to retain in
the output.
}
  \item{possiblePloidies}{
A list of numeric vectors indicating potential inheritance modes of SNPs in the
dataset.  See \code{\link{RADdata}}.
}
  \item{taxaPloidy}{
A single integer, or an integer vector with one value per taxon, indicating
ploidy.  See \code{\link{RADdata}}.
}
  \item{contamRate}{
A number ranging from zero to one (typically small) indicating the expected 
rate of sample cross-contamination.
}
  \item{dbfile}{
Optionally, name of the Tag Manager database file.
}
  \item{dbColumnsToKeep}{
Optionally, a character vector indicating the names of columns to keep
from the database file.
}
  \item{dbChrCol}{
The name of the column containing the chromosome number in the database file.
}
  \item{dbPosCol}{
The name of the column indicating alignment position in the database file.
}
  \item{dbNameCol}{
The name of the column containing marker names in the database file.
}
}
\details{
Nucleotides associated with the alleles, to be stored in the 
\code{$alleleNucleotides} slot, are extracted from the allele names in the
read counts file.  It is assumed that the allele names first contain the
marker name, followed by an underscore, followed by the nucleotide(s) at
any variable positions.
}
\value{
A \code{"\link{RADdata}"} object.
}
\references{
\url{https://github.com/lvclark/tagdigger}

Clark, L. V. and Sacks, E. J. (2016) TagDigger: User-friendly extraction 
of read counts from GBS and RAD-seq data.  \emph{Source Code for Biology
and Medicine} \bold{11}, 11.
}
\author{
Lindsay V. Clark
}

\seealso{
\code{\link{readHMC}}, \code{\link{readStacks}}, \code{\link{VCF2RADdata}},
\code{\link{readTASSELGBSv2}}, \code{\link{readDArTag}}
}
\examples{
# for this example we'll create dummy files
countfile <- tempfile()
write.csv(data.frame(row.names = c("Sample1", "Sample2", "Sample3"),
                     Mrkr1_A_0 = c(0, 20, 4),
                     Mrkr1_G_1 = c(7, 0, 12)),
          file = countfile, quote = FALSE)
dbfile <- tempfile()
write.csv(data.frame(Marker.name = "Mrkr1", Chr = 5, Pos = 66739827),
          file = dbfile, row.names = FALSE, quote = FALSE)

# read the data
myrad <- readTagDigger(countfile, dbfile = dbfile)
}

\keyword{ file }
