context("methods rbind and cbind")

test_that("rbind", {
  init_data()

  res <- rbind(2, pm_first, pm_second, matrix(1:6, 2, 3), p(1, 2, 3, 4))
  expect_equal(res,
               polyMatrix(matrix(c(2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                   1, 1, 0, 1, 0, 3, 2, 4, 0, 0, 0, 0,
                                   0, 2, 0, 3, 0, 0, 1, 0, 0, 0, 0, 0,
                                   3, 0, 1, 0, 0, 0, 0, 6, 0, 0, 0, 0,
                                   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                   0, 0, 1, 0, 0, 2, 0, 0, 3, 0, 0, 0,
                                   0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                   1, 3, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                   2, 4, 6, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                                   1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4), 10, 12, byrow = TRUE),
                          10, 3, 3))
})

test_that("cbind", {
  init_data()

  res <- cbind(2, pm_first, pm_second, matrix(1:6, 3, 2), p(1, 2, 3, 4))
  expect_equal(
    res,
    polyMatrix(matrix(
      c(2, 1, 1, 0, 0, 0, 0, 1, 4, 1, 0, 1, 0, 3, 0, 0, 0, 0, 0, 2, 0, 2, 4, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 4,
        2, 0, 2, 0, 0, 0, 1, 2, 5, 1, 0, 3, 0, 0, 0, 0, 2, 0, 0, 2, 0, 1, 0, 0, 0, 0, 3, 0, 0, 3, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 4,
        2, 3, 0, 1, 0, 0, 0, 3, 6, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 0, 6, 0, 0, 0, 0, 0, 0, 3, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 4), 3, 40, byrow = TRUE
    ), 3, 10, 3)
  )
})