% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_03_app_users.R
\name{update_app_user}
\alias{update_app_user}
\title{Polished API - Update an App User}
\usage{
update_app_user(app_uid, user_uid, is_admin = FALSE, api_key = get_api_key())
}
\arguments{
\item{app_uid}{the app uid to update.}

\item{user_uid}{the user uid to update.}

\item{is_admin}{boolean (default: \code{FALSE}) - whether or not the user is an admin.}

\item{api_key}{your Polished API key.  Set your polished api key using \code{\link{set_api_key}()}
so that you do not need to supply this argument with each function call.}
}
\value{
an object of class \code{polished_api_res}.  When successful, the \code{content} of the
\code{polished_api_res} is \code{list(message = "success")}.  In the case of an error, the
content is \code{list(error = "<error message>")}.
}
\description{
Polished API - Update an App User
}
\seealso{
\code{\link[=get_app_users]{get_app_users()}} \code{\link[=add_app_user]{add_app_user()}} \code{\link[=delete_app_user]{delete_app_user()}}
}
