% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/password_input.R
\name{password_input}
\alias{password_input}
\title{A modification of \code{shiny::passwordInput}}
\usage{
password_input(
  input_id,
  label = htmltools::tagList(icon("unlock-alt"), "Password"),
  value = "",
  style = "",
  placeholder = NULL
)
}
\arguments{
\item{input_id}{The \code{input} slot that will be used to access the value.}

\item{label}{Display label for the control, or \code{NULL} for no label.}

\item{value}{Initial value.}

\item{style}{Character string of in-line CSS to style the input.}

\item{placeholder}{A character string giving the user a hint as to what can
be entered into the control. Internet Explorer 8 and 9 do not support this option.}
}
\value{
the UI to create a password input.
}
\description{
This modified version of Shiny's \code{passwordInput()} does not actually send the password
to our Shiny server.  It is just a regular password input that always keeps your
user's password on the client.  The password is used to sign the user in and then
converted to a JWT by Firebase, all on the client, before it is sent to your Shiny
server.
}
