% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/firebase_dependencies.R
\name{firebase_dependencies}
\alias{firebase_dependencies}
\title{Load the Firebase JavaScript dependencies into the UI}
\usage{
firebase_dependencies(services = c("auth"), firebase_version = "7.15.5")
}
\arguments{
\item{services}{character vector of Firebase services to load into the UI.  Valid strings are
\code{"auth"} (default), \code{"firestore"}, \code{"functions"}, \code{"messaging"}, and \code{"storage"}}

\item{firebase_version}{character string of the Firebase version.  Defaults to \code{"7.15.5"}.}
}
\value{
the HTML \code{<script>} tags for the Firebase JavaScript dependencies
}
\description{
Under the hood, \code{polished} uses Firebase JavaScript dependencies to handle
Social sign in & user authentication when \code{sign_in_providers} besides \code{"email"}
are included in \code{polished_config()}. This function loads the required Firebase JavaScript dependencies
in the the UI of your Shiny app.
}
\examples{

firebase_dependencies()

}
