% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.r
\name{utils_gsub_if_found}
\alias{utils_gsub_if_found}
\title{Conditionally amend character string vector.}
\usage{
utils_gsub_if_found(
  regex_filter,
  string_filter,
  regex_search,
  string_replace,
  string_search,
  default,
  ignore_case_filter,
  ignore_case_search
)
}
\arguments{
\item{regex_filter}{Pattern to look for provided as a character string regex.}

\item{string_filter}{Character string vector to search into for the pattern
provided in \code{regex_filter} above.}

\item{regex_search}{Alternative pattern provided as a character string regex
to look in the alternative character string provided in \code{string_search}
below.}

\item{string_replace}{Substitution character string for matches of
\code{regex_search} above in \code{string_search} below.}

\item{string_search}{Alternative character string to search into for the
pattern provided in \code{regex_search} above.}

\item{default}{Character string returned if pattern provided in \code{regex_filter}
not found.}

\item{ignore_case_filter}{Boolean specifying whether case should be ignored (\code{TRUE})
or not (\code{FALSE}) in search for \code{regex_filter} in \code{string_filter}.}

\item{ignore_case_search}{Boolean specifying whether case should be ignored (\code{TRUE})
or not (\code{FALSE}) in search for \code{regex_search} in \code{string_search}.}
}
\value{
A character string vector.
}
\description{
Searches for specified pattern in provided character string vector. If found,
substitutes all occurrences of an alternative pattern in an alternative
character string and returns the output. If not return the default character
string provided.
}
\examples{
\dontrun{
  utils_gsub_if_found(
    "^glasgow", c("glasgow-entrepreneurs", "aberdeen-entrepreneurs"),
    "(?<=-).+$", "merchant", "edinburgh-entrepreneurs", "pattern not found",
    TRUE, TRUE
  )
}
}
