% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine.r
\name{combine_match_general_to_trades_plain}
\alias{combine_match_general_to_trades_plain}
\title{Match general to trades directory records}
\usage{
combine_match_general_to_trades_plain(
  trades_directory,
  general_directory,
  verbose,
  matches,
  ...
)
}
\arguments{
\item{trades_directory}{A Scottish post office trades directory in the form
of a data.frame or other object that inherits from the data.frame class
such as a \code{\link[tibble]{tibble}}. Columns must at least include
\code{surname}, \code{forename}, \code{address.trade.number}, \code{address.trade.body}.}

\item{general_directory}{A Scottish post office general directory in the form
of a data.frame or other object that inherits from the data.frame class
such as a \code{\link[tibble]{tibble}}. Columns must at least include
\code{surname}, \code{forename}, \code{address.trade.number}, \code{address.trade.body},
\code{address.house.number}, \code{address.house.body}.}

\item{verbose}{Whether the function should be executed silently (\code{FALSE}) or
not (\code{TRUE}).}

\item{matches}{Whether (\code{TRUE}) or not (\code{FALSE}) a column 'match' showing
general directory matches' name and address(es) should be added to the
output dataset.}

\item{...}{Further arguments to be passed down to
\code{\link[fuzzyjoin]{stringdist_left_join}}.}
}
\value{
A data.frame of the same class as that of the one provided in
\code{trades_directory} and/or \code{general_directory}. Should \code{trades_directory} and
\code{general_directory}be provided as objects of different classes, the class of
the return data.frame will be that of the parent class. i.e. if
\code{trades_directory} and \code{general_directory} are provided as a pure data.frame
and a \code{\link[tibble]{tibble}} respectively, a pure data.frame is
returned. Columns include at least \code{surname}, \code{forename},
\code{address.trade.number}, \code{address.trade.body}, \code{address.house.number},
\code{address.house.body}.
}
\description{
Attempts to complement Scottish post office trades directory data.frame with
house address information from the Scottish post office general directory
data.frame provided by matching records from the two datasets using the
distance metric specified.
}
\seealso{
\code{\link{combine_match_general_to_trades}}.
}
