% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dgr_table.R
\name{dgr_table}
\alias{dgr_table}
\title{Generate a summary table of descriptive data for every individual in a dataset suitable for tabulation in a report.}
\usage{
dgr_table(
  dat,
  fields,
  names,
  cutoff = 7,
  sig = 3,
  by = NULL,
  idvar = "ID",
  navars = c("-99", "-999"),
  mtype = "geomean"
)
}
\arguments{
\item{dat}{An input data frame, with one row per unique individual.}

\item{fields}{A vector of strings containing the names of the fields to be included in the summary table.}

\item{names}{A vector of strings containing descriptive names for the fields to be included in the summary table.}

\item{cutoff}{An integer defining the maximum number of unique values a variable should have to be considered categorical. Fields with more than this number of unique values are considered continuous for the purposes of the summary table (defaults to 7).}

\item{sig}{The number of significant digits summary values should have (defaults to 3).}

\item{by}{The field to use for grouping (a string). If not \code{NULL} (the default), the summary table will contain columns for each unique value of this field, as well as a column summarizing across all fields.}

\item{idvar}{The field in the dataset identifying each unique individual (defaults to "ID").}

\item{navars}{A vector containing values that are to be interpreted as missing (defaults to "-99" and "-999"). \code{NA} values are always considered to be missing.}

\item{mtype}{The type of mean to apply; \code{geomean}, the geometric mean (default) or \code{mean}, the arithmetic mean.}
}
\value{
A data frame containing a summary of all the fields listed in \code{fields}, for each individual in the dataset (the dataset should not contain duplicated individuals), conditioned on the field in \code{by}. Continuous values are summarized as median, mean, range and number of missing values. Categorical values are summarized as count and relative percentage.
}
\description{
Generate a summary table of descriptive data for every individual in a dataset suitable for tabulation in a report.
}
\examples{
\dontrun{
 count_na(c(0,5,7,NA,3,3,NA))
}

}
\author{
Justin Wilkins, \email{justin.wilkins@occams.com}
}
