% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/der_vs_state_nlmixr.R
\name{ind_der_state_plot_nlmixr}
\alias{ind_der_state_plot_nlmixr}
\title{Generate Derivative versus State Plot for individual parameter estimates (nlmixr2)}
\usage{
ind_der_state_plot_nlmixr(
  nn_name,
  min_state = NULL,
  max_state = NULL,
  inputs = NULL,
  est_parms = NULL,
  fit_obj = NULL,
  length_out = 100,
  time_nn = FALSE,
  ribbon = TRUE,
  act = "ReLU",
  beta = 20
)
}
\arguments{
\item{nn_name}{(string) Name of the NN, e.g., \dQuote{c} for NNc(...)}

\item{min_state}{(numeric) Value of minimal state for which the derivative should be calculated (optional if inputs is given, ignored if inputs is defined)}

\item{max_state}{(numeric) Value of maximal state for which the derivative should be calculated (optional if inputs is given, ignored if inputs is defined)}

\item{inputs}{(numeric vector) Vector of input values for which derivatives should be calculated (optional if min_state and max_state is given)}

\item{est_parms}{(named vector; semi-optional) A data frame with estimated individual parameters from the NN 
extracted through the \emph{indparm_extractor_nlmixr} function. For optionality, see \strong{Details}.}

\item{fit_obj}{(nlmixr fit object; semi-optional) The fit-object from nlmixr2(...), fitted with IIV. For optionality, see \strong{Details}.}

\item{length_out}{(numeric) Number of points between min_state and max_state}

\item{time_nn}{(boolean) Whether the neural network to analyze is a time-dependent neural network or not. Default values is FALSE.}

\item{ribbon}{(boolean) Whether individual derivatives versus states should be summarise in a ribbon (TRUE) or
displayed as individual spaghetti plot (FALSE)}

\item{act}{(string) Activation function used in the NN. Currently "ReLU" and "Softplus" available.}

\item{beta}{(numeric) Beta value for the Softplus activation function, only applicable if \emph{act="Softplus"}; Default to 20.}
}
\value{
Displaying derivative versus state plot
}
\description{
This functions allows to generate a derivative versus state plot for a neural network from a NODE in nlmixr2
with individual parameter estimates (EBEs).
}
\details{
Either \emph{est_parms} or \emph{fit_obj} must be given. If both arguments are given, \emph{est_parms} is prioritized.
}
\examples{
\dontrun{
ind_fit <- nlmxir2(node_model_ind,data=data,est="saem")
der_state_plot <- ind_der_state_plot_nlmixr(nn="c",min_state=0,max_state=10,
                                            fit_obj=ind_fit)
}
}
\author{
Dominic Bräm
}
