% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/example3-sv.R
\name{example3_sv}
\alias{example3_sv}
\title{Parameter estimation in a simple stochastic volatility model}
\usage{
example3_sv(noBurnInIterations = 2500, noIterations = 7500,
  noParticles = 500, initialTheta = c(0, 0.9, 0.2),
  stepSize = diag(c(0.1, 0.01, 0.05)^2), syntheticData = FALSE)
}
\arguments{
\item{noBurnInIterations}{The number of burn-in iterations in the PMH
algorithm. Must be smaller than \code{noIterations}.}

\item{noIterations}{The number of iterations in the PMH algorithm. 100
iterations takes about a minute on a laptop to execute.}

\item{noParticles}{The number of particles to use when estimating the likelihood.}

\item{initialTheta}{The initial guess of the parameters theta.}

\item{stepSize}{The step sizes of the random walk proposal. Given as a covariance
matrix.}

\item{syntheticData}{If TRUE, data is not downloaded from the Internet. This is only used when running tests of the package.}
}
\value{
The function returns the estimated marginal parameter posteriors for each
parameter, the trace of the Markov chain and the resulting autocorrelation
function. The data is also presented with an estimate of the
log-volatility.

The function returns a list with the elements:
\itemize{
\item{thhat: The estimate of the mean of the parameter posterior.}
\item{xhat: The estimate of the mean of the log-volatility posterior.}
\item{thhatSD: The estimate of the standard deviation of the parameter
posterior.}
\item{xhatSD: The estimate of the standard deviation of the log-volatility
posterior.}
\item{iact: The estimate of the integrated autocorrelation time for each
parameter.}
\item{estCov: The estimate of the covariance of the parameter posterior.}
\item{theta: The trace of the chain exploring the parameter posterior.}
}
}
\description{
Minimal working example of parameter estimation in a stochastic volatility
model using the particle Metropolis-Hastings algorithm with a bootstrap
particle filter providing an unbiased estimator of the likelihood. The
code estimates the parameter posterior for three parameters using
real-world data.
}
\details{
The Particle Metropolis-Hastings (PMH) algorithm makes use of a Gaussian
random walk as the proposal for the parameters. The data are scaled
log-returns from the OMXS30 index during the period from January 2, 2012
to January 2, 2014.

This version of the code makes use of a somewhat well-tuned proposal as a
pilot run to estimate the posterior covariance and therefore increase the
mixing of the Markov chain.
}
\note{
See Section 5 in the reference for more details.
}
\examples{
\dontshow{
    example3_sv(noBurnInIterations=5, noIterations=10, noParticles=50, syntheticData=TRUE)
}
\dontrun{
    example3_sv(noBurnInIterations=200, noIterations=1000)
}
}
\references{
Dahlin, J. & Schon, T. B. "Getting Started with Particle 
Metropolis-Hastings for Inference in Nonlinear Dynamical Models." 
Journal of Statistical Software, Code Snippets,
88(2): 1--41, 2019.
}
\author{
Johan Dahlin \email{uni@johandahlin.com}
}
\keyword{misc}
