% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_compare.R
\name{geom_compare}
\alias{geom_compare}
\title{add p value and fold change on a plot}
\usage{
geom_compare(
  mapping = NULL,
  data = NULL,
  stat = "compare",
  position = "identity",
  ...,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  lab_pos = NULL,
  step_increase = 0.1,
  tip_length = 0.02,
  lineend = "round",
  cp_label = c("psymbol"),
  ns_lineheight_just = 0.2,
  ignore_ns = FALSE,
  fc_method = NULL,
  comparisons = NULL,
  paired = FALSE,
  alternative = "two.sided",
  test_method = "wilcoxon",
  ns_symbol = "NS",
  cp_ref = NULL,
  cp_inline = FALSE,
  brackets_widen = 0,
  fc_digits = 2,
  cp_result = NULL,
  cp_manual = NULL
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{stat}{The statistical transformation to use on the data for this
layer, either as a \code{ggproto} \code{Geom} subclass or as a string naming the
stat stripped of the \code{stat_} prefix (e.g. \code{"count"} rather than
\code{"stat_count"})}

\item{position}{Position adjustment, either as a string naming the adjustment
(e.g. \code{"jitter"} to use \code{position_jitter}), or the result of a call to a
position adjustment function. Use the latter if you need to change the
settings of the adjustment.}

\item{...}{Other arguments passed on to \code{ggplot2::geom_segment()}.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{lab_pos}{position of the label brackets}

\item{step_increase}{the increase height for next bracket,
a ratio according to the whole panel height}

\item{tip_length}{the length for tips at the ends of the brackets,
a ratio according to the whole panel height}

\item{lineend}{Line end style (round, butt, square).}

\item{cp_label}{which values will be add on the plot, a character vector
with some of \verb{psymbol, p, right_deno_fc, left_deno_fc} in it.
If \code{comparisons} is assigned, you can also include \verb{fc1, fc2}}

\item{ns_lineheight_just}{if show \code{psymbol} in the label, justify
the \code{NS} labels to make the lineheights look balanced}

\item{ignore_ns}{if \code{TRUE} will ignore all label items if p >= 0.05,
or you can assign a character vector like \code{cp_label} to ignore some items
of the label}

\item{fc_method}{fold change method, default is \code{mean}. If you use \code{log10} or
\code{log2} axis, default is \code{geom_mean}.}

\item{comparisons}{a list of two-element vector, to assign the comparisons
should be performed}

\item{paired}{paired test or not, \code{FALSE} as default. If \code{TRUE}, you should
use mapping=aes(paired_by=col) to indicate pairs by an extra column}

\item{alternative}{one of \verb{two.sided, greater, less}}

\item{test_method}{\code{wilcoxon} as default, one of \verb{wilcoxon, t}}

\item{ns_symbol}{the symbol of non-significant, \code{NS} as default}

\item{cp_ref}{reference item, the others will be compared with it}

\item{cp_inline}{draw in line or not, default is \code{FALSE}}

\item{brackets_widen}{widen the brackets, can be a negative value}

\item{fc_digits}{fold change digits}

\item{cp_result}{comparation result tibble}

\item{cp_manual}{manual comparisons table,
please refer to \code{extract_compare()}}
}
\value{
\code{ggplot} object
}
\description{
add p value and fold change on a plot
}
