% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{checkAndConvert}
\alias{checkAndConvert}
\title{Check and convert input object to sfc_POINT object}
\usage{
checkAndConvert(x)
}
\arguments{
\item{x}{A generic object.}
}
\value{
An object of class sfc_POINT.
}
\description{
Checks on the input object and any conversions:

- Check that the input object is of length 1, if it is not an error appears.

- Verifies that the input object is of the sfc (Simple Features Collection) class, if it is not, it returns NA and reports a warning.

- If the input object is of sfc class, checks that it is of type POINT, if it is not, the centroid of the geometric object is calculated.

- If the input object is of the sfc_POINT class, check that it has a reference system and that this is the WGS84 for the decimal coordinates; if it is not, it is set or converted.
}
\examples{
library(sf)
checkAndConvert(0)
###
polygon <- st_sfc(st_polygon(list(cbind(c(0, 1, 1, 0, 0), c(0, 0, 1, 1, 0)))))
checkAndConvert(polygon)
###
point <- st_sfc(st_point(c(0, 0)))
checkAndConvert(point)
}
