% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plug.R
\name{plug_execute_query}
\alias{plug_execute_query}
\title{Execute a custom SQL query on the Plug database}
\usage{
plug_execute_query(
  sql_template,
  endpoint = "https://plug.der.pe.gov.br/MadrixApi/executeQuery",
  verbosity = 0,
  ...
)
}
\arguments{
\item{sql_template}{A SQL query template with placeholders for variables.}

\item{endpoint}{The endpoint URL for executing queries.}

\item{verbosity}{The verbosity level of the API request (0 = none, 1 = minimal, 2 = detailed).}

\item{...}{Named arguments to replace placeholders in the SQL template.}
}
\value{
A tibble containing the query results.
}
\description{
This function executes a user-defined SQL query on the Plug database, with safe query construction
using \code{glue_sql}.
}
\examples{
\donttest{
\dontrun{
data <- plug_execute_query(sql_template = "SELECT TOP 1 * FROM Contratos_VIEW")
}
}
}
