% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_cut_point.R
\name{plot_cut_point}
\alias{plot_cut_point}
\title{Plots Cut Point from Gaussian Mixture Models}
\usage{
plot_cut_point(m, plot = TRUE, color = c("grayscale", "amerika", "wesanderson"))
}
\arguments{
\item{m}{An object of class \code{mixEM} corresponding with the fit GMM}

\item{plot}{A logical argument for generating the plot. If FALSE, only the cut point value from the GMM is returned. If TRUE, histogram with the overlaid cut point is returned. Default is set to TRUE.}

\item{color}{A vector of color options including "amerika" (from package \code{amerika}), "wesanderson" (from package \code{wesanderson}), and "grayscale", which is the default option.}
}
\description{
Returns a plot of the data density (histogram) with an overlaid cut point generated by a Gaussian mixture model
}
\details{
Gaussian mixture models are often used to derive cut points, or lines of separation between clusters in feature space (See Benaglia et al. 2009 for more). The \code{plot_cut_point} function plots data densities with the overlaid cut point (the mean of the calculated \code{mu}) from \code{mixEM} objects, which are GMM's fit using the \code{mixtools} package.
}
\examples{
mixmdl <- mixtools::normalmixEM(faithful$waiting, k = 2)

plot_cut_point(mixmdl, plot = TRUE, color = "amerika") # returns plot, amerika
plot_cut_point(mixmdl, plot = TRUE, color = "wesanderson") # returns plot, wesanderson
plot_cut_point(mixmdl, plot = FALSE) # returns only the cut point value from the GMM
}
\references{
Benaglia, T., Chauveau, D., Hunter, D. and Young, D. 2009. mixtools: An R package for analyzing finite mixture models. Journal of Statistical Software, 32(6), pp.1-29.

Ram, K., and Wickham, H. 2015. wesanderson: a Wes Anderson palette generator. R package version 0.3.
}
