% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_shapefile.R
\name{shapefile_build}
\alias{shapefile_build}
\title{Build a shapefile from a mosaic raster}
\usage{
shapefile_build(
  mosaic,
  basemap = NULL,
  controlpoints = NULL,
  r = 3,
  g = 2,
  b = 1,
  crop_to_shape_ext = TRUE,
  grid = TRUE,
  nrow = 1,
  ncol = 1,
  nsides = 200,
  plot_width = NULL,
  plot_height = NULL,
  layout = "lrtb",
  serpentine = TRUE,
  build_shapefile = TRUE,
  check_shapefile = FALSE,
  sf_to_polygon = FALSE,
  buffer_edge = 1,
  buffer_col = 0,
  buffer_row = 0,
  as_sf = TRUE,
  verbose = TRUE,
  max_pixels = 1e+06,
  downsample = NULL,
  quantiles = c(0, 1)
)
}
\arguments{
\item{mosaic}{A \code{SpatRaster} object, typically imported using
\code{\link[=mosaic_input]{mosaic_input()}}.  If not provided, a latitude/longitude basemap will be
generated in the "EPSG:4326" coordinate reference system.}

\item{basemap}{An optional \code{mapview} object.}

\item{controlpoints}{An \code{sf} object created with \code{\link[mapedit:editMap]{mapedit::editMap()}},
containing the polygon that defines the region of interest to be analyzed.}

\item{r, g, b}{The layer for the Red, Green and Blue band, respectively.
Defaults to \code{1}, \code{2}, and \code{3}.}

\item{crop_to_shape_ext}{Crop the mosaic to the extension of shapefile?
Defaults to \code{TRUE}. This allows for a faster index computation when the
region of the built shapefile is much smaller than the entire mosaic
extension.}

\item{grid}{Logical, indicating whether to use a grid for segmentation
(default: TRUE).}

\item{nrow}{Number of rows for the grid (default: 1).}

\item{ncol}{Number of columns for the grid (default: 1).}

\item{nsides}{The number of sides if the geometry is generated with \verb{Draw Circle} tool.}

\item{plot_width, plot_height}{The width and height of the plot shape (in the
mosaic unit). It is mutually exclusiv with \code{buffer_col} and \code{buffer_row}.}

\item{layout}{Character: one of
\itemize{
\item \code{'tblr'} for top/bottom left/right orientation
\item \code{'tbrl'} for top/bottom right/left orientation
\item \code{'btlr'} for bottom/top left/right orientation
\item \code{'btrl'} for bottom/top right/left orientation
\item \code{'lrtb'} for left/right top/bottom orientation
\item \code{'lrbt'} for left/right bottom/top orientation
\item \code{'rltb'} for right/left top/bottom orientation
\item \code{'rlbt'} for right/left bottom/top orientation
}}

\item{serpentine}{Create a serpentine-based layout? Defaults to \code{FALSE}.}

\item{build_shapefile}{Logical, indicating whether to interactively draw ROIs
if the shapefile is \code{NULL} (default: TRUE).}

\item{check_shapefile}{Logical, indicating whether to validate the shapefile
with an interactive map view (default: TRUE). This enables live editing of
the drawn shapefile by deleting or changing the drawn grids.}

\item{sf_to_polygon}{Convert sf geometry like POINTS and LINES to POLYGONS?
Defaults to \code{FALSE}. Using \code{TRUE} allows using POINTS to extract values
from a raster using \code{exactextractr::exact_extract()}.}

\item{buffer_edge}{Width of the buffer around the shapefile (default: 5).}

\item{buffer_col, buffer_row}{Buffering factor for the columns and rows,
respectively, of each individual plot's side. A value between 0 and 0.5
where 0 means no buffering and 0.5 means complete buffering (default: 0). A
value of 0.25 will buffer the plot by 25\% on each side.}

\item{as_sf}{Logical value indicating whether to convert the imported
shapefile to an \code{sf} object (default is \code{TRUE}).}

\item{verbose}{Logical, indicating whether to display verbose output
(default: TRUE).}

\item{max_pixels}{Maximum number of pixels to render in the map or plot
(default: 500000).}

\item{downsample}{Downsampling factor to reduce the number of pixels
(default: NULL). In this case, if the number of pixels in the image (width
x height) is greater than \code{max_pixels} a downsampling factor will be
automatically chosen so that the number of plotted pixels approximates the
\code{max_pixels}.}

\item{quantiles}{the upper and lower quantiles used for color stretching.}
}
\value{
A list with the built shapefile. Each element is an \code{sf} object with
the coordinates of the drawn polygons.
}
\description{
This function takes a mosaic raster to create a shapefile containing polygons
for the specified regions. Users can drawn Areas of Interest (AOIs) that can
be either a polygon with n sides, or a grid, defined by \code{nrow}, and \code{ncol}
arguments.
}
\details{
Since multiple blocks can be created, the length of arguments \code{grid}, \code{nrow},
\code{ncol}, \code{buffer_edge}, \code{buffer_col}, and \code{buffer_row} can be either an scalar
(the same argument applied to all the drawn blocks), or a vector with the
same length as the number of drawn blocks. In the last, shapefiles in each
block can be created with different dimensions.
}
\examples{
if (interactive() && requireNamespace("EBImage")) {
library(pliman)
mosaic <- mosaic_input(system.file("ex/elev.tif", package="terra"))
shps <-
      shapefile_build(mosaic,
                      nrow = 6,
                      ncol = 3,
                      buffer_row = -0.05,
                      buffer_col = -0.25,
                      check_shapefile = FALSE,
                      build_shapefile = FALSE) ## Use TRUE to interactively build the plots
mosaic_plot(mosaic)
shapefile_plot(shps[[1]], add = TRUE)
}

}
