% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theta_estimates.R
\name{theta.estimates}
\alias{theta.estimates}
\title{Computes estimates of theta (values on latent trait(s)) for all LMA models}
\usage{
theta.estimates(inData, model.fit)
}
\arguments{
\item{inData}{Matrix of response patterns}

\item{model.fit}{Object containing output from running ple.lma}
}
\value{
theta.est 	 A person by trait matrix of values on the latent traits
}
\description{
The final estimates of the item scale values and the conditional
covariance matrix (i.e, Phi.mat) are used to compute values on latent
traits for each individual or case.  The estimated thetas are the
(conditional) mean values of response patterns. The correlations
between the estimated thetas equal the marginal correlations.
}
\examples{
 data(dass)
 inData <- dass[1:250,c("d1", "d2", "d3", "a1","a2","a3","s1","s2","s3")]
 inTraitAdj  <- matrix(1, nrow=1, ncol=1)
 inItemTraitAdj <- matrix(1, nrow=9, ncol=1)

 r1 <- ple.lma(inData, model.type="rasch", inItemTraitAdj, inTraitAdj)
 theta.r1 <- theta.estimates(inData, r1)

\donttest{
g1 <- ple.lma(inData, model.type="gpcm", inItemTraitAdj, inTraitAdj)
theta.g1 <- theta.estimates(inData, g1)

n1 <- ple.lma(inData, model.type="nominal", inItemTraitAdj,inTraitAdj)
theta.n1 <- theta.estimates(inData, n1)
}

}
