% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assign.R
\name{assign}
\alias{assign}
\title{Tracks genets through time}
\usage{
assign(
  dat,
  inv,
  dorm,
  buff,
  buffGenet,
  clonal,
  flagSuspects = FALSE,
  shrink = 0.1,
  dormSize = 0.05,
  inheritsFromTrackSpp = FALSE,
  nearEdgeBox = NULL,
  ...
)
}
\arguments{
\item{dat}{An sf data.frame of the same format as
\code{\link{grasslandData}}. 'dat' must contain data for only one species in
one quadrat. It must have columns that contain...
\itemize{
\item a unique identification for each research site in character format
with no NAs (the default column name is "Site")
\item species name in character format with no NAs (the default column
name is "Species")
\item unique quadrat identifier in character format with no NAs (the default
column name is "Quad")
\item year of data collection in integer format with no NAs (the
default column name is "Year")
\item an s.f 'geometry' column that contains a= polygon or multipolygon data type
for each individual observation (the default column name is "geometry")
}

This function will add columns called "basalArea_ramet", "trackID",
"age", "size_tplus1", "recruit" and "survives_tplus1", so 'dat' should not
contain columns with these names.}

\item{inv}{An integer vector that contains all of years in which this quadrat
(or other unique spatial area) was sampled. Years must be
ordered sequentially.}

\item{dorm}{A numeric vector of length 1, indicating the number of years this
species is allowed to go dormant, i.e. be absent from the map but be
considered the same individual when it reappears. This must be an integer
greater than or equal to 0.}

\item{buff}{A numeric vector of length 1 that is greater than or equal to
zero, indicating how far (in the same units as spatial values in 'dat') a
polygon can move from year \code{t} to year \code{t+1} and still be
considered the same individual.}

\item{buffGenet}{A numeric vector of length 1 that is greater than or equal
to zero, indicating how close (in the same units as spatial values in 'dat')
polygons must be to one another in the same year to be grouped as a genet
(if 'clonal' argument = TRUE). This argument is passed to
the \code{\link{groupByGenet}} function, which is used inside the
\code{\link{assign}} function.}

\item{clonal}{A logical argument of length 1, indicating whether this
species is allowed to be clonal or not (i.e. if multiple polygons (ramets)
can be grouped into one individual (genet)). If clonal = TRUE, the species is
allowed to be clonal, and if clonal = FALSE, the species is not allowed to
be clonal.}

\item{flagSuspects}{A logical argument of length 1, indicating whether
observations that are 'suspect' will be flagged. The default is
\code{flagSuspects = FALSE}. If \code{flagSuspects = TRUE}, then a column called
'Suspect' is added to the output data.frame. Any suspect observations get a
'TRUE' in the 'Suspect' column, while non-suspect observations receive a
'FALSE'. There are two ways that an observation can be classified as
'suspect'. First, if two consecutive observations have the same trackID, but
the basal area of the observation in year \code{t+1} is less that a certain
percentage (defined by the \code{shrink} arg.) of the basal area of the
observation in year t, it is possible that the observation in year \code{t+1}
is a new recruit and not the same individual. The second way an observation
can be classified as 'suspect' is if it is very small before going dormant.
It is unlikely that a very small individual will survive dormancy, so it is
possible that the function has mistakenly given a survival value of '1' to
this individual. A 'very small individual' is any observation with an area
below a certain percentile (specified by 'dormSize') of the size distribution
for this species, which is generated using all of the size data for this
species in 'dat'.}

\item{shrink}{A single numeric value. This value is only used when
\code{flagSuspects = TRUE}. When two consecutive observations have the same
trackID, and the ratio of size_t+1 to size_t is smaller than the value of
\code{shrink}, the observation in year \code{t} gets a 'TRUE' in the 'Suspect'
column. For example, \code{shrink = 0.2}, and an individual that the tracking
function has identified as 'BOUGRA_1992_5' has an area of 9 cm^2 in
year \code{t} and an area of 1.35 cm^2 in year \code{t+1}. The ratio of
size \code{t+1} to size \code{t} is 1.35/9 = 0.15, which is smaller than the
cutoff specified by \code{shrink}, so the observation of BOUGRA_1992_5' in year
\code{t} gets a 'TRUE' in the 'Suspect' column. The default value
is \code{shrink = 0.10}.}

\item{dormSize}{A single numeric value. This value is only used when
\code{flagSuspects = TRUE} and \code{dorm} is greater than or equal to 1. An individual
is flagged as 'suspect'
if it 'goes dormant' and has a size that is less than or equal to the
percentile of the size distribution for this species that is designated by
\code{dormSize}. For example, \code{dormSize = 0.05}, and the focal individual has a
basal area of 0.5 cm^2. The 5th percentile of the distribution of size for
this species, which is made using the mean and standard deviation of all
observations in 'dat' for the species in question, is 0.6 cm^2. This
individual does not have any overlaps in the next year (year \code{t+1}), but
does have an overlap in year \code{t+2}. However, because the basal area of
this observation is smaller than the 5th percentile of size for this species,
the observation in year \code{t} will get a 'TRUE' in the 'Suspect' column.
It is possible that the tracking function has mistakenly assigned a '1' for
survival in year t, because it is unlikely that this individual is large
enough to survive dormancy. The default value is \code{dormSize = .05}.}

\item{inheritsFromTrackSpp}{A logical argument that is only applicable when
'assign()' is used internally in 'trackSpp()'.}

\item{nearEdgeBox}{An sf data frame indicating the bounding box of the
quadrat. This argument is only used if 'assign()' is used internally
in 'trackSpp()'.}

\item{...}{Other arguments passed on to methods. Not currently used.}
}
\description{
This function tracks individual organisms through time, but only
for one species in one quadrat. It is designed for use within the
\code{\link{trackSpp}} function, and is not intended for use on its own.
}
\details{
see \code{\link{trackSpp}} for details of arguments and usage.
}
\seealso{
\code{\link[=trackSpp]{trackSpp()}}, which is a wrapper for the \code{\link[=assign]{assign()}} function that
applies it over many species and quadrats. The \code{\link[=assign]{assign()}} function uses the
\code{\link[=groupByGenet]{groupByGenet()}} function to group ramets into genets
(if 'clonal' argument = TRUE).
}
