% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install.R
\name{mcsim_install}
\alias{mcsim_install}
\alias{mcsim_version}
\alias{set_rtools40_path}
\title{Download and install \pkg{GNU MCSim}}
\usage{
mcsim_install(version = "6.2.0", install_dir = NULL, mxstep = 5000)

mcsim_version()

set_rtools40_path()
}
\arguments{
\item{version}{a character of version number.}

\item{install_dir}{a character to assign the installed directory.}

\item{mxstep}{a numeric value to assign the maximum number of (internally defined) steps
allowed during one call to the solver.}
}
\description{
Download the latest or specific version of \pkg{GNU MCSim} from the official website
(\url{https://www.gnu.org/software/mcsim/}) and install it to the system directory.
}
\details{
This function aims to help users download (source: https://ftp.gnu.org/gnu/mcsim/)
and install \pkg{GNU MCSim} more easily.
However, if you can not install it through this function.
The additional way is to follow the instruction and install it manually:
\url{https://www.gnu.org/software/mcsim/mcsim.html#Installation}

The default \code{mxstp} is setting to 5000.
The user can increase \code{mxstp} to avoid possible error return.
If you meet any error when conduct sensitivity analysis,
you can use this function to re-install \pkg{GNU MCSim} and set the higher \code{mxstp}.
The default installed \code{directory} is under \code{/home/username} (Linux),
\code{/Users/username} (MacOS),
and \code{C:/Users/username/Documents} (windows).
To install \pkg{GNU MCSim} in Windows, be sure to install Rtools first.
The current suggested Rtools version is 4.0.
}
\section{Functions}{
\itemize{
\item \code{mcsim_version()}: Return the version number.

\item \code{set_rtools40_path()}: the function to set Rtools40 path

}}
\references{
Bois, F. Y., & Maszle, D. R. (1997).
MCSim: a Monte Carlo simulation program.
\emph{Journal of Statistical Software}, 2(9): 1–60.

\url{https://www.gnu.org/software/mcsim/}
}
