% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fixDuplicates.R
\name{fixDuplicates}
\alias{fixDuplicates}
\title{Remove Duplicate Dose Data}
\usage{
fixDuplicates(
  data,
  idVar = "id",
  infusionDoseTimeVar = NULL,
  infusionDoseVar = NULL,
  moveBolus = FALSE,
  bolusDoseTimeVar = NULL,
  bolusDoseVar = NULL
)
}
\arguments{
\item{data}{data.frame; data set with dose information}

\item{idVar}{character string; name of ID variable, defaults to id}

\item{infusionDoseTimeVar}{character string; name of infusion dose time
variable}

\item{infusionDoseVar}{character string; name of infusion dose variable}

\item{moveBolus}{logical; allow duplicate infusion doses to be categorized
as bolus}

\item{bolusDoseTimeVar}{character string; name of bolus dose time variable}

\item{bolusDoseVar}{character string; name of bolus dose variable}
}
\value{
data.frame, containing dose data
}
\description{
Modify dose data to remove duplicate dose values.
}
\details{
Some duplicates can be adjusted by changing the date-time rounding.
Others may be converted from one dose type to another, such as moving
infusion to bolus.
}
\author{
Cole Beck
}
