% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pfm.R
\name{read_pfm}
\alias{read_pfm}
\title{Read PFM image}
\usage{
read_pfm(filename)
}
\arguments{
\item{filename}{PFM filename or connection object. If filename ends with 
'xz', 'bz2' or 'gz' suffix then it will be uncompressed automatically.}
}
\value{
If input PFM file is grayscale, a 2D numeric array is returned.
        If PFM file represents RGB color values, a 3D numeric array is returned.
}
\description{
Read PFM image
}
\examples{
file <- system.file("image/rstats.pfm.bz2", package = "picohdr")
arr <- read_pfm(file)
arr[1:5, 1:5, ]

# Tone-map the image, gamma correct and plot
arr <- tm_reinhard_basic(arr)
arr <- adj_gamma(arr)
plot(arr)

}
\seealso{
Other PFM functions: 
\code{\link{write_pfm}()}
}
\concept{PFM functions}
