% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/M_statistic.R
\name{gower_dist}
\alias{gower_dist}
\title{Calculate Gower distance}
\usage{
gower_dist(x, type = list(), dist_format = c("matrix", "dist"))
}
\arguments{
\item{x}{A data frame. The columns usually represent trait data, and the row names are species names.}

\item{type}{A list for specifying the variable types of the columns in \code{x}.
Default is numeric type. More details in \code{\link[cluster:daisy]{cluster::daisy()}}.}

\item{dist_format}{The class of the return value. Default is "matrix".}
}
\value{
A matrix or dist object containing the Gower distance among the rows of \code{x}.
}
\description{
\code{gower_dist()} calculates Gower distance among observations or species.
}
\examples{
data("turtles")
# Continuous trait
trait_df <- data.frame(M1 = turtles$traits$M1, row.names = turtles$traits$specie)
trait_dist <- gower_dist(x = trait_df)

# Nominal discrete trait
trait_df <- data.frame(B1 = turtles$traits$B1, row.names = turtles$traits$specie)
trait_dist <- gower_dist(x = trait_df, type = list(factor = 1))

# Ordinal discrete trait
trait_df <- data.frame(CS1 = turtles$traits$CS1, row.names = turtles$traits$specie)
trait_dist <- gower_dist(x = trait_df, type = list(ordered = 1))

# Multi-trait Combinations
trait_df <- data.frame(turtles$traits[, c("M1", "M2", "M3", "M4", "M5")],
                       row.names = turtles$traits$specie)
trait_dist <- gower_dist(x = trait_df, type = list(factor = c("M4", "M5")))

}
\references{
Gower, J.C. (1971) A general coefficient of similarity and some of its properties. Biometrics: 857-871.

Kaufman, L. & Rousseeuw, P.J. (1990) Finding Groups in Data: An Introduction to Cluster Analysis. Wiley, New York.
}
\seealso{
\code{\link[cluster:daisy]{cluster::daisy()}} which this function wraps.
}
