% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functional_beta.R
\name{functional_beta}
\alias{functional_beta}
\title{Functional beta diversity for mixed-type functional traits}
\usage{
functional_beta(
  x,
  trait = NULL,
  bin = 10,
  na.rm = "no",
  quick_elbow = FALSE,
  abundance = FALSE,
  ...
)
}
\arguments{
\item{x}{A dataframe or sparse community matrix of species occurrences.}

\item{trait}{A data frame with the first column labeled \dQuote{species}
containing the taxonomic groups to be evaluated whereas the remaining
columns contain the various functional traits. The variables should be
mixed-type combining numeric and categorical variables.}

\item{bin}{The desired number of clusters or bins. If \code{elbow=TRUE},
the optimal number of clusters is determined by running the analysis
multiple times varying from 2 to bin.}

\item{na.rm}{Logical, whether NA values should be removed prior to
computation}

\item{quick_elbow}{Quickly estimate the 'elbow' of a scree plot to determine
the optimal number of clusters.}

\item{abundance}{Logical, whether the reduced matrix should be returned as
presence or absence of cluster representation or as abundances of cluster
memberships}

\item{\dots}{Further arguments passed to or from other methods.}
}
\value{
A list with three dissimilarity matrices capturing: (i) turnover
(replacement), (ii) nestedness-resultant component, and (iii) total
dissimilarity (i.e. the sum of both components).

For index.family="sorensen"
the three matrices are:
\itemize{
  \item \code{beta.sim} A distance object, dissimilarity matrix accounting
  for spatial turnover (replacement), measured as Simpson pair-wise
  dissimilarity.
  \item \code{beta.sne} \code{dist} object, dissimilarity matrix accounting for
  nestedness-resultant dissimilarity, measured as the nestedness-fraction
  of Sorensen pair-wise dissimilarity
  \item \code{beta.sor} \code{dist} object, dissimilarity matrix accounting
  for total dissimilarity, measured as Sorensen pair-wise dissimilarity
  (a monotonic transformation of beta diversity)
}
For index.family="jaccard" the three matrices are:
\itemize{
  \item \code{beta.jtu} A distance object, dissimilarity matrix accounting
  for spatial turnover, measured as the turnover-fraction of Jaccard
  pair-wise dissimilarity
  \item \code{beta.jne} \code{dist} object, dissimilarity matrix accounting
  for nestedness-resultant dissimilarity, measured as the
  nestedness-fraction of Jaccard pair-wise dissimilarity
  \item \code{beta.jac} \code{dist} object, dissimilarity matrix accounting
  for beta diversity, measured as Jaccard pair-wise dissimilarity (a
  monotonic transformation of beta diversity)
}
}
\description{
Computes turnover of functional diversity using k-prototypes clustering
algorithm tailored for mixed-type functional traits (numeric and
categorical) to generate an integer vector of cluster assignments. The
ranges of each species in a cluster are collapsed to generate a new
community matrix based on the presence or absence of cluster membership
in a grid cell. A grade of membership model or beta diversity is then fitted
to the new reduced community matrix for further analysis.
}
\examples{
\donttest{
library(terra)
data(africa)
p <- vect(system.file("ex/sa.json", package = "phyloregion"))
fb <- functional_beta(x=africa$comm, trait = africa$trait)
p <- phyloregion(fb[[1]], pol = p)
plot(p)
}
}
\references{
Szepannek, G. (2018) clustMixType: User-friendly clustering of mixed-type
data in R. \emph{The R Journal}, \strong{10}: 200-208.
}
