% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_licor.R
\name{read_licor}
\alias{read_licor}
\title{Read a LI-COR file}
\usage{
read_licor(
  file,
  bluestem_version = get_bluestem_version(file, n_max = 10L),
  ...
)
}
\arguments{
\item{file}{Path to a raw LI6800 file}

\item{bluestem_version}{Character string of Bluestem software version number. By default, the function will try to pull the version number from file.}

\item{...}{Argument passed to \code{\link[readr]{read_lines}}}
}
\value{
Returns a \code{\link[tibble]{tibble}} from raw LI-COR LI6800 files.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Reads a raw LI-COR LI6800 file, including remarks. This function was
developed using output from Bluestem v.2.0.04 to v.2.1.08. We cannot
guarantee backward compatibility with earlier versions of Bluestem. We will
try to update code when new versions are released, but there maybe a
time-lag, so inspect results carefully.
}
