% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waveband.class.r
\name{wl_max}
\alias{wl_max}
\alias{max}
\alias{max.waveband}
\alias{max.generic_spct}
\alias{max.generic_mspct}
\title{Wavelength maximum}
\usage{
wl_max(x, na.rm = FALSE)

\method{max}{waveband}(..., na.rm = FALSE)

\method{max}{generic_spct}(..., na.rm = FALSE)

\method{max}{generic_mspct}(..., na.rm = FALSE, idx = "spct.idx")
}
\arguments{
\item{x}{generic_spct, generic_mspct or waveband object.}

\item{na.rm}{ignored}

\item{...}{numeric, \code{waveband} or \code{generic_spct} arguments.}

\item{idx}{character Name of the column with the names of the members of the
collection of spectra.}
}
\value{
a length-one vector for individual objects or numeric vectors
  or a data frame for collections of spectra.
}
\description{
A method specialization that returns the wavelength maximum [\eqn{nm}] from
objects of classes \code{waveband} or of class \code{generic_spct} or
derived.
}
\section{Methods (by class)}{
\itemize{
\item \code{max(generic_spct)}: 

\item \code{max(generic_mspct)}: 

}}
\examples{
max(sun.spct)
wl_max(sun.spct)

}
