#' Names of different indexing vectors
#'
#' The package makes available character vectors that can be used to extract
#' spectral data for specific subsets of the filters, screens, etc. Some
#' correspond to supplier names, others to materials, types, colours and typical
#' uses. The data objects described here list the names of all these vectors
#' of names grouped by the collection of spectra they index.
#'
#' @docType data
#' @keywords datasets
#' @format A vector of character strings.
#'
#' @seealso \code{\link{filters.mspct}} and \code{\link{screens_nets.mspct}}
#'
#' @examples
#' all_screen_net_selectors
#' all_filter_selectors
#'
#' @rdname all_selectors
#' @aliases selectors
#'
"all_filter_selectors"

#' @rdname all_selectors
"all_screen_net_selectors"
