% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitCDM.R
\name{fitCDM}
\alias{fitCDM}
\title{Fit a CDM Model}
\usage{
fitCDM(x, z, connect = NULL, nGibbs = 1000, nBurnin = 1, n.adapt = 100,
  n.chains = 4, quiet = FALSE, calcLatentGibbs = FALSE, trend = +1)
}
\arguments{
\item{x}{Matrix of predictors [N x p].}

\item{z}{Vector of response values [N x 1].}

\item{connect}{The connectivity matrix for the z vector [n x 2]. Each row contains the last and next elements of the time-series. NA values indicate not connected.}

\item{nGibbs}{Number of MCMC itterations}

\item{nBurnin}{Number of burn-in itterations.}

\item{n.adapt}{Number of itterations for adaptive sampling}

\item{n.chains}{Number of MCMC chains}

\item{quiet}{logical value indicating whether to report the progress}

\item{calcLatentGibbs}{logical value indicating whether to calculate the latent states}

\item{trend}{time-series expected trend as -1:decreasing, +1:increasing, 0: not constrained}
}
\description{
This function fits a CDM model on the input data as it is described by the phenoSim function.
}
\examples{

#Summarize CDM Model Ouput

ssSim <- phenoSim(nSites = 2, #number of sites
                  nTSet = 30, #number of Time steps
                  beta = c(1, 2), #beta coefficients
                  sig = .01, #process error
                  tau = .1, #observation error
                  plotFlag = TRUE, #whether plot the data or not
                  miss = 0.05, #fraction of missing data
                  ymax = c(6, 3) #maximum of saturation trajectory
)

ssOut <- fitCDM(x = ssSim$x, #predictors
                nGibbs = 200,
                nBurnin = 100,
                z = ssSim$z,#response
                connect = ssSim$connect, #connectivity of time data
                quiet=TRUE)

summ <- getGibbsSummary(ssOut, burnin = 100, sigmaPerSeason = FALSE)

colMeans(summ$ymax)
colMeans(summ$betas)
colMeans(summ$tau)
colMeans(summ$sigma)

}
\keyword{CDM}
\keyword{Fit}
\keyword{Model}
