% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nTTP.array.R
\name{nTTP.array}
\alias{nTTP.array}
\title{Generate the nTTP dictionary}
\usage{
nTTP.array(wm, toxmax)
}
\arguments{
\item{wm}{(numeric matrix, m by n) Toxicity weighted matrix, with row
be the type of the toxicity and column be the toxicity grade}

\item{toxmax}{(scalar)         Normalized constant for nTTP}
}
\value{
An m dimensional array with dimension \eqn{(n, n, \ldots, n)}. The
  \eqn{(d1, d2 ,\ldots,dm), {di, i = 1\ldots, m} \in (1, \ldots, n)}th
  element is the nTTP when the grade of \eqn{i}th type of toxicity has
  \eqn{di}th toxicity grade.
}
\description{
\code{nTTP.array} generates the nTTP dictionary for all combination of
toxicity type and grade with a given toxicity weighted matrix. Used in
function \code{\link{nTTP_summary}} for checking the toxicity scenario.
}
\examples{
wm = matrix(c(0, 0.5, 0.75, 1, 1.5,
              0, 0.5, 0.75, 1, 1.5,
              0, 0, 0, 0.5, 1),
            byrow = TRUE, ncol = 5)          # weighted matrix for toxicity matrix
                                             # nrow = No.of type; ncol = No. of grade
toxmax = 2.5

nTTP.array(wm, toxmax)

}
