% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SA_lookup.R
\name{SA_lookup}
\alias{SA_lookup}
\title{Lookup Table for Sensitivity Analysis}
\usage{
SA_lookup(CorXM, CorXY, CorMY)
}
\arguments{
\item{CorXM}{The observed correlation between predictor X and mediator M.}

\item{CorXY}{The observed correlation between predictor X and outcome Y.}

\item{CorMY}{The observed correlation between mediator M and outcome Y.}
}
\value{
Results of a sensitivity analysis with varying cross-lagged and autoregressive correlations.
}
\description{
\code{SA_lookup()} is used to look up the sensitivity analysis results for a two-wave mediation model when provided with the cross-sectional correlations.
}
\examples{
# specify correlations
xm <- .2
xy <- .3
my <- .4

output <- SA_lookup(
  CorXM = xm,
  CorXY = xy,
  CorMY = my
)
}
