% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_eppo_token.R
\name{check_eppo_token}
\alias{check_eppo_token}
\title{EPPO Data Services token variable}
\usage{
check_eppo_token(token)
}
\arguments{
\item{token}{object of class pestr_token.}
}
\value{
Silent NULL when there is no error, otherwise message.
}
\description{
\ifelse{html}{\out{<a href='https://www.tidyverse.org/lifecycle/#maturing'><img src='figures/lifecycle-maturing.svg' alt='Maturing lifecycle'></a>}}{\strong{Maturing}}
\code{check_eppo_token} should be used after \code{create_eppo_token}
to check if the token is correctly recognized by EPPO Data Services API.
As a reference it uses link to \emph{Xylella fastidiosa} hosts database -
\strong{XYLEFA} eppocode.
If token is recognized there will be no message. In other cases function will
show following messages: No internet connection or Forbidden (HTTP 403).
}
\examples{
\dontrun{
eppo_token <- create_eppo_token("abcdef123456")
check_eppo_token(eppo_token)
}
}
\seealso{
To obtain your free EPPO token please register
to \strong{EPPO Data Services} \url{https://data.eppo.int/}
}
