% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weighted_svm.R
\name{weighted.ksvm}
\alias{weighted.ksvm}
\title{Fit weighted kernel svm model.}
\usage{
weighted.ksvm(
  y,
  x,
  weights,
  C = c(0.1, 0.5, 1, 2, 10),
  kernel = "rbfdot",
  kpar = "automatic",
  nfolds = 10,
  foldid = NULL,
  eps = 1e-08,
  ...
)
}
\arguments{
\item{y}{The response vector (either a character vector, factor vector, or numeric vector with values in {-1, 1})}

\item{x}{The design matrix (not including intercept term)}

\item{weights}{vector of sample weights for weighted SVM}

\item{C}{cost of constraints violation, see \code{\link[kernlab]{ksvm}}}

\item{kernel}{kernel function used for training and prediction. See \code{\link[kernlab]{ksvm}} and \code{\link[kernlab]{kernels}}}

\item{kpar}{list of hyperparameters for the kernel function. See \code{\link[kernlab]{ksvm}}}

\item{nfolds}{number of cross validation folds for selecting value of C}

\item{foldid}{optional vector of values between 1 and nfolds specifying which fold each observation is in. If specified, it will
override the \code{nfolds} argument.}

\item{eps}{penalty nugget parameter. Defaults to \code{1e-8}}

\item{...}{extra arguments to be passed to \code{\link[kernlab]{ipop}} from the kernlab package}
}
\description{
Fits weighted kernel SVM.  To be used for OWL with hinge loss (but can be used more generally)
}
\examples{

library(kernlab)

x <- matrix(rnorm(200 * 2), ncol = 2)

y <- 2 * (sin(x[,2]) ^ 2 * exp(-x[,2]) - 0.2 > rnorm(200, sd = 0.1)) - 1

weights <- runif(100, max = 1.5, min = 0.5)

wk <- weighted.ksvm(x = x[1:100,], y = y[1:100],
                    C = c(0.1, 0.5, 1, 2),
                    nfolds = 5,
                    weights = weights[1:100])

pr <- predict(wk, newx = x[101:200,])

mean(pr == y[101:200])

}
\seealso{
\code{\link[personalized]{predict.wksvm}} for predicting from fitted \code{weighted.ksvm} objects
}
