% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities-internal.R
\name{.find_stable_bdb_bisquare}
\alias{.find_stable_bdb_bisquare}
\title{Determine a breakdown point with stable numerical properties of the M-scale
with Tukey's bisquare rho function.}
\usage{
.find_stable_bdb_bisquare(
  n,
  desired_bdp,
  tolerance = 0.01,
  precision = 1e-04,
  interval = c(0.05, 0.5)
)
}
\arguments{
\item{n}{number of observations in the sample}

\item{desired_bdp}{the desired breakdown point (between 0.05 and 0.5)}

\item{tolerance}{how far can the chosen bdp be away from the desired bdp.
The chosen bdp is guaranteed to be in the range given by \code{interval}.}

\item{precision}{granularity of the grid of considered bdp's.}

\item{interval}{restrict the chosen bdp to this interval.}
}
\description{
The M-scale objective (and hence the S-loss) can have unbounded or very high
1st derivative. This can lead to numerical instability of the algorithms and
in turn excessive computation time.
This function chooses the breakdown point with lowest upper bound of the 1st
derivative from a range of bdp's in the vicinity of the desired bdp.
}
\keyword{internal}
