% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/control_options.R
\name{cd_algorithm_options}
\alias{cd_algorithm_options}
\title{Coordinate Descent (CD) Algorithm to Compute Penalized Elastic Net
S-estimates}
\usage{
cd_algorithm_options(
  max_it = 1000,
  reset_it = 8,
  linesearch_steps = 4,
  linesearch_mult = 0.5
)
}
\arguments{
\item{max_it}{maximum number of iterations.}

\item{reset_it}{number of iterations after which the residuals are
re-computed from scratch, to prevent numerical drifts from incremental
updates.}

\item{linesearch_steps}{maximum number of steps used for line search.}

\item{linesearch_mult}{multiplier to adjust the step size in the line
search.}
}
\value{
options for the CD algorithm to compute (adaptive) PENSE estimates.
}
\description{
Set options for the CD algorithm to compute adaptive EN S-estimates.
}
\seealso{
mm_algorithm_options to optimize the non-convex PENSE objective
function via a sequence of convex problems.
}
