% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class.R
\docType{class}
\name{penfaSampleStats-class}
\alias{penfaSampleStats-class}
\title{S4 Class for describing the sample moments}
\description{
The \code{penfaSampleStats} class provides information on the
sample moments of the factor analysis model. This
class is an adaptation of the \code{lavSampleStats} class from the
\href{https://CRAN.R-project.org/package=lavaan}{lavaan} package.
}
\section{Slots}{

\describe{
\item{\code{var}}{List of the variances of the observed variables in every group.}

\item{\code{cov}}{List of the covariance matrices of the observed variables
in every group.}

\item{\code{mean}}{List of the means of the observed variables in every group.}

\item{\code{group.w}}{List of group weights.}

\item{\code{nobs}}{List of the effective number of observations for every group.}

\item{\code{ntotal}}{Integer. Total number of observations across all groups.}

\item{\code{ngroups}}{Integer. Number of groups.}

\item{\code{icov}}{List of the inverse matrices of the covariance matrices of the
observed variables in every group.}

\item{\code{cov.log.det}}{List of the logarithms of the determinants of the
covariance matrices of the observed variables for every group.}
}}

\examples{

data(ccdata)

syntax = 'help  =~   h1 + h2 + h3 + h4 + h5 + h6 + h7 + 0*v1 + v2 + v3 + v4 + v5
          voice =~ 0*h1 + h2 + h3 + h4 + h5 + h6 + h7 +   v1 + v2 + v3 + v4 + v5'

alasso_fit <- penfa(## factor model
                    model  = syntax,
                    data   = ccdata,
                    std.lv = TRUE,
                    ## penalization
                    pen.shrink = "alasso",
                    eta = list(shrink = c("lambda" = 0.01), diff = c("none" = 0)),
                    ## automatic procedure
                    strategy = "auto")

alasso_fit@SampleStats

}
\seealso{
\code{\link{penfa}}
}
