% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outputHelpers.R
\name{plot_trace}
\alias{plot_trace}
\title{Plot MCMC Trace Plots}
\usage{
plot_trace(results, n_chains, verbose = FALSE)
}
\arguments{
\item{results}{A list of MCMC chain results.}

\item{n_chains}{Integer, the number of chains.}

\item{verbose}{Logical, whether to print progress messages. Default is FALSE.}
}
\value{
No return value, called for side effects. Creates trace plots for each parameter.
}
\description{
Plot MCMC Trace Plots
}
\examples{
# Create example results list
results <- list(
  list(
    median_samples = rnorm(100),
    threshold_samples = runif(100),
    first_quartile_samples = rgamma(100, 2, 2),
    asymptote_samples = rbeta(100, 2, 2)
  )
)

# Generate trace plots
plot_trace(results, n_chains = 1)
}
