% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cs_per.R
\name{cs_per}
\alias{cs_per}
\title{Generate design matrix for periodic cubic splines}
\usage{
cs_per(x, knots = NULL, nk = 5, xmax = max(x, na.rm = TRUE),
  xmin = min(x, na.rm = TRUE))
}
\arguments{
\item{x}{numerical x values to transform to new basis}

\item{knots}{vector with locations of the knots of the spline}

\item{nk}{number of knots, used only if the knots are not specified, overridden otherwise}

\item{xmax}{value of the (theoretical) minimum of x}

\item{xmin}{value of the (theoretical) maximum of x}
}
\description{
Generate design matrix for periodic cubic splines.
}
\examples{
# load example data; see help("viral_east_mediteranean")
data("viral_east_mediteranean")

# calculate location of knots to use
Knots <- 
 Hmisc::rcspline.eval(x = viral_east_mediteranean$EpiWeek,
                      nk = 5, knots.only = TRUE)

# model viral infections vs weeks
model <- glm(RSV ~ cs_per(EpiWeek, knots = Knots), data = viral_east_mediteranean)

# plot model (with many points, to make it smooth)
plot_per_mod(Model = model, XvarName = "EpiWeek", Smooth = TRUE)

}
