% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AB_permutation_test_plot.R
\name{AB_permutation_test_plot}
\alias{AB_permutation_test_plot}
\title{AB_permutation_test_plot}
\usage{
AB_permutation_test_plot(
  x,
  x_values,
  y,
  test_statistic_function = "mean",
  de_A_trend = FALSE,
  detrend_A_position = "center",
  show_de_A_trended = FALSE,
  de_B_trend = FALSE,
  detrend_B_position = "center",
  show_de_B_trended = FALSE,
  show_plot_header = "",
  xlab = "",
  ylab = "",
  ylim = NULL,
  labels = NULL,
  line_colors = c("blue", "red", "blue", "red", "blue", "cyan"),
  show_legend = TRUE
)
}
\arguments{
\item{x}{factor vector to indicate conditions or phases (e.g., "A" and "B")}

\item{x_values}{numerical vector with distance (time markers) between observations}

\item{y}{numerical vector with the observed y-values}

\item{test_statistic_function}{character compute and compare "mean" or "median" for phase A and B}

\item{de_A_trend}{boolean de-trend A (optional)}

\item{detrend_A_position}{character c("first", "center", "last"), see detrend_A}

\item{show_de_A_trended}{boolean show de-trend A line (optional)}

\item{de_B_trend}{boolean de-trend B (optional)}

\item{detrend_B_position}{character c("first", "center", "last"), see detrend_B}

\item{show_de_B_trended}{boolean show de-trend B line (optional)}

\item{show_plot_header}{character header}

\item{xlab}{character x-axis label}

\item{ylab}{character y-axis label}

\item{ylim}{numerical vector of y-axis limits}

\item{labels}{character vector of labels}

\item{line_colors}{character vector with colors of the succeeding lines c("blue", "red", "blue", "red", "blue", "cyan"),}

\item{show_legend}{boolean show legend}
}
\value{
NULL.
}
\description{
Creates a permutation distancing test plot.
Several plot options are available, e.g., to show both the observed and detrended lines.
}
\examples{
pdt::AB_permutation_test_plot(
  as.factor(c(rep("A",20), rep("B",20))),
  1:40,
  c(rnorm(20), rnorm(20)+2),
  test_statistic_function="mean",
  de_A_trend=TRUE,
  detrend_A_position="center",
  show_de_A_trended=TRUE,
  de_B_trend=TRUE,
  detrend_B_position="center",
  show_de_B_trended=TRUE,
  show_plot_header="",
  xlab="",
  ylab="",
  ylim=NULL,
  labels=NULL,
  line_colors=c("blue", "red", "blue", "red", "blue", "cyan"),
  show_legend=TRUE)

}
