% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summ_center.R
\name{summ_center}
\alias{summ_center}
\alias{summ_mean}
\alias{summ_median}
\alias{summ_mode}
\alias{summ_midrange}
\title{Summarize distribution with center}
\usage{
summ_center(f, method = "mean")

summ_mean(f)

summ_median(f)

summ_mode(f, method = "global")

summ_midrange(f)
}
\arguments{
\item{f}{A pdqr-function representing distribution.}

\item{method}{Method of center computation. For \code{summ_center()} is one of
"mean", "median", "mode", "midrange". For \code{summ_mode()} is one of "global"
or "local".}
}
\value{
\code{summ_center()}, \code{summ_mean()}, \code{summ_median()} and \verb{summ_mode(*, method = "global")} always return a single number representing a center of
distribution. \verb{summ_mode(*, method = "local")} can return a numeric vector
with multiple values representing local maxima.
}
\description{
Functions to compute center of distribution. \code{summ_center()} is a wrapper for
respective \verb{summ_*()} functions (from this page) with default arguments.
}
\details{
\code{summ_mean()} computes distribution's mean.

\code{summ_median()} computes a smallest \code{x} value for which cumulative
probability is not less than 0.5. Essentially, it is a \code{as_q(f)(0.5)}. This
also means that for pdqr-functions with type "discrete" it always returns an
entry of "x" column from \code{f}'s \link[=meta_x_tbl]{"x_tbl" metadata}.

\verb{summ_mode(*, method = "global")} computes a smallest \code{x} (which is an entry
of "x" column from \code{f}'s \code{x_tbl}) with the highest probability/density.
\verb{summ_mode(*, method = "local")} computes all \code{x} values which represent
non-strict \strong{local maxima} of probability mass/density function.

\code{summ_midrange()} computes middle point of \code{f}'s \link[=meta_support]{support}
(average of left and right edges).
}
\examples{
# Type "continuous"
d_norm <- as_d(dnorm)
## The same as `summ_center(d_norm, method = "mean")`
summ_mean(d_norm)
summ_median(d_norm)
summ_mode(d_norm)
## As pdqr-functions always have finite support, output here is finite
summ_midrange(d_norm)

# Type "discrete"
d_pois <- as_d(dpois, lambda = 10)
summ_mean(d_pois)
summ_median(d_pois)
## Returns the smallest `x` with highest probability
summ_mode(d_pois)
## Returns all values which are non-strict local maxima
summ_mode(d_pois, method = "local")
## As pdqr-functions always have finite support, output here is finite
summ_midrange(d_pois)

# Details of computing local modes
my_d <- new_d(data.frame(x = 11:15, y = c(0, 1, 0, 2, 0) / 3), "continuous")
## Several values, which are entries of `x_tbl`, are returned as local modes
summ_mode(my_d, method = "local")
}
\seealso{
\code{\link[=summ_spread]{summ_spread()}} for computing distribution's spread, \code{\link[=summ_moment]{summ_moment()}}
for general moments.

Other summary functions: 
\code{\link{summ_classmetric}()},
\code{\link{summ_distance}()},
\code{\link{summ_entropy}()},
\code{\link{summ_hdr}()},
\code{\link{summ_interval}()},
\code{\link{summ_moment}()},
\code{\link{summ_order}()},
\code{\link{summ_prob_true}()},
\code{\link{summ_pval}()},
\code{\link{summ_quantile}()},
\code{\link{summ_roc}()},
\code{\link{summ_separation}()},
\code{\link{summ_spread}()}
}
\concept{summary functions}
