% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pdfminer.R
\name{layout_control}
\alias{layout_control}
\title{Read a \code{PDF} document.}
\usage{
layout_control(
  line_overlap = 0.5,
  char_margin = 2,
  line_margin = 0.5,
  word_margin = 0.1,
  boxes_flow = 0.5,
  detect_vertical = FALSE,
  all_texts = FALSE
)
}
\arguments{
\item{line_overlap}{a double, if two characters have more overlap than this 
they are considered to be on the same line. The overlap is specified
relative to the minimum height of both characters.}

\item{char_margin}{a double, if two characters are closer together than this
margin they are considered part of the same line. The margin is
specified relative to the width of the character.}

\item{line_margin}{a double, if two characters on the same line are further 
apart than this margin then they are considered to be two separate words, 
and an intermediate space will be added for readability. The margin is
specified relative to the width of the character.}

\item{word_margin}{a double, if two lines are are close together they are
considered to be part of the same paragraph. The margin is specified 
relative to the height of a line.}

\item{boxes_flow}{a double, Specifies how much a horizontal and vertical 
position of a text matters when determining the order of text boxes. 
The value should be within the range of \code{-1.0} (only horizontal 
position matters) to \code{+1.0} (only vertical position matters). 
You can also pass \code{NULL} to disable advanced layout analysis, 
and instead return text based on the position of the bottom left corner 
of the text box.}

\item{detect_vertical}{a logical, If vertical text should be considered during
layout analysis}

\item{all_texts}{a logical, If layout analysis should be performed on text 
in figures.}
}
\value{
Returns a list with the layout control variables.
}
\description{
Extract  \code{PDF} document
}
\examples{
layout_control()
}
