% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcvreg.R
\name{pcvreg}
\alias{pcvreg}
\title{Procrustes cross-validation for multivariate regression models}
\usage{
pcvreg(
  X,
  Y,
  ncomp = min(nrow(X) - 1, ncol(X), 30),
  cv = list("ven", 4),
  center = TRUE,
  scale = FALSE,
  funlist = list(),
  cv.scope = "global"
)
}
\arguments{
\item{X}{matrix with predictors from the training set.}

\item{Y}{vector with response values from the training set.}

\item{ncomp}{number of components to use (more than the expected optimal number).}

\item{cv}{which split method to use for cross-validation (see description of method `pcvpls()` for details).}

\item{center}{logical, to center or not the data sets}

\item{scale}{logical, to scale or not the data sets}

\item{funlist}{list with functions for particular implementation}

\item{cv.scope}{scope for center/scale operations inside CV loop: 'global' — using globally computed mean and std
or 'local' — recompute new for each local calibration set.}
}
\description{
This is a generic method, use `pcvpls()` or `pcvpcr()` instead.
}
