% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_linear_combo.R
\name{model_prcomp}
\alias{model_prcomp}
\title{Model the principal component score of a set of phenotypes using PCSS}
\usage{
model_prcomp(
  formula,
  comp = 1,
  n,
  means,
  covs,
  center = FALSE,
  standardize = FALSE,
  ...
)
}
\arguments{
\item{formula}{an object of class \code{formula} whose dependent variable is
a series of variables joined by \code{+} operators. \code{model_prcomp}
will treat a principal component score of those variables as the actual
dependent variable. All model terms must be accounted for in \code{means}
and \code{covs}.}

\item{comp}{integer indicating which principal component score to analyze.
Must be less than or equal to the total number of phenotypes.}

\item{n}{sample size.}

\item{means}{named vector of predictor and response means.}

\item{covs}{named matrix of the covariance of all model predictors and the
responses.}

\item{center}{logical. Should the dependent variables be centered before
principal components are calculated?}

\item{standardize}{logical. Should the dependent variables be standardized 
before principal components are calculated?}

\item{...}{additional arguments}
}
\value{
an object of class \code{"pcsslm"}.

  An object of class \code{"pcsslm"} is a list containing at least the 
  following components:
    \item{call}{the matched call}
    \item{terms}{the \code{terms} object used}
    \item{coefficients}{a \eqn{p x 4} matrix with columns for the 
      estimated coefficient, its standard error, t-statistic and
      corresponding (two-sided) p-value.}
    \item{sigma}{the square root of the estimated variance of the random
      error.}
    \item{df}{degrees of freedom, a 3-vector \eqn{p, n-p, p*}, the
      first being the number of non-aliased coefficients, the last being
      the total number of coefficients.}
    \item{fstatistic}{a 3-vector with the value of the F-statistic with its
      numerator and denominator degrees of freedom.}
    \item{r.squared}{\eqn{R^2}, the 'fraction of variance explained by the 
      model'.}
    \item{adj.r.squared}{the above \eqn{R^2} statistic \emph{'adjusted'},
      penalizing for higher \eqn{p}.}
    \item{cov.unscaled}{a \eqn{p x p} matrix of (unscaled) covariances of the
      \eqn{coef[j], j=1,...p}.}
    \item{Sum Sq}{a 3-vector with the model's Sum of Squares Regression 
      (SSR), Sum of Squares Error (SSE), and Sum of Squares Total (SST).}
}
\description{
\code{model_prcomp} calculates the linear model for the mth principal
  component score of a set of phenotypes as a function of a set of
  predictors.
}
\examples{
ex_data <- pcsstools_example[c("g1", "x1", "x2", "y1", "y2", "y3")]
head(ex_data)
means <- colMeans(ex_data)
covs <- cov(ex_data)
n <- nrow(ex_data)

model_prcomp(
  y1 + y2 + y3 ~ g1 + x1 + x2,
  comp = 1, n = n, means = means, covs = covs
)
}
\references{
{
  
  \insertRef{wolf_computationally_2020}{pcsstools}
  
}
}
