% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClassFunctions.R
\name{summary.PCDs}
\alias{summary.PCDs}
\title{Return a summary of a \code{PCDs} \code{object}}
\usage{
\method{summary}{PCDs}(object, ...)
}
\arguments{
\item{object}{An \code{object} of class \code{PCDs}.}

\item{\dots}{Additional parameters for \code{summary}.}
}
\value{
The \code{call} of the \code{object} of class \code{"PCDs"},
the \code{type} of the proximity catch digraph (PCD),
(i.e. the description of the PCD), some of the partition
(i.e. intervalization in the 1D case and triangulation
in the 2D case) points
(i.e., vertices of the intervals or the triangles),
parameter(s) of the PCD, and various quantities
(number of vertices,
number of arcs and arc density of the PCDs,
number of vertices for the partition
and number of partition cells
(i.e., intervals or triangles)).
}
\description{
Returns the below information about the \code{object}:

\code{call} of the function defining the \code{object},
the \code{type} of the proximity catch digraph (PCD),
(i.e. the description of the PCD),
some of the partition
(i.e. intervalization in the 1D case and triangulation
in the 2D case) points
(i.e., vertices of the intervals or the triangles),
parameter(s) of the PCD, and various quantities
(number of vertices,
number of arcs and arc density of the PCDs,
number of vertices for the partition and number of partition cells
(i.e., intervals or triangles)).
}
\examples{
\donttest{
A<-c(1,1); B<-c(2,0); C<-c(1.5,2);
Tr<-rbind(A,B,C);
n<-10
Xp<-runif.tri(n,Tr)$g
M<-as.numeric(runif.tri(1,Tr)$g)
Arcs<-arcsAStri(Xp,Tr,M)
Arcs
summary(Arcs)
}

}
\seealso{
\code{\link{print.PCDs}},
\code{\link{print.summary.PCDs}},
and \code{\link{plot.PCDs}}
}
