% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AuxExtrema.R
\name{six.extremaTe}
\alias{six.extremaTe}
\title{The closest points among a data set
in the standard equilateral triangle
to the median lines in the six  half edge regions}
\usage{
six.extremaTe(Xp, ch.all.intri = FALSE)
}
\arguments{
\item{Xp}{A set of 2D points
among which the closest points in the standard equilateral triangle
to the median lines in 6 half edge regions.}

\item{ch.all.intri}{A logical argument
for checking whether all data points are in \eqn{T_e}
(default is \code{FALSE}).}
}
\value{
A \code{list} with the elements
\item{txt1}{Region labels as r1-r6
(correspond to row number in Extremum Points).}
\item{txt2}{A short description of the distances
as \code{"Distances to Line Segments (A,CM), (B,CM),
and (C,CM) in the six regions r1-r6"}.}
\item{type}{Type of the extrema points}
\item{mtitle}{The \code{"main"} title for the plot of the extrema}
\item{ext}{The extrema points, here,
closest points in each of regions \code{r1-r6} to the line segments
joining vertices to the center of mass, \eqn{CM}.}
\item{X}{The input data, \code{Xp},
can be a \code{matrix} or \code{data frame}}
\item{num.points}{The number of data points, i.e., size of \code{Xp}}
\item{supp}{Support of the data points, here, it is \eqn{T_e}.}
\item{cent}{The center point used for construction of edge regions.}
\item{ncent}{Name of the center, \code{cent},
it is center of mass \code{"CM"} for this function.}
\item{regions}{The six regions, \code{r1-r6}
and edge regions inside the triangle, \eqn{T_e}, provided as a list.}
\item{region.names}{Names of the regions
as \code{"r1"}-\code{"r6"} and
names of the edge regions as \code{"er=1"}, \code{"er=2"},
and \code{"er=3"}.}
\item{region.centers}{Centers of mass of the regions \code{r1-r6}
and of edge regions inside \eqn{T_e}.}
\item{dist2ref}{Distances from closest points
in each of regions \code{r1-r6} to the line segments
joining vertices to the center of mass, \eqn{CM}.}
}
\description{
An object of class \code{"Extrema"}.
Returns the six closest points among the data set, \code{Xp},
in the standard equilateral triangle
\eqn{T_e=T(A=(0,0),B=(1,0),C=(1/2,\sqrt{3}/2))} in half edge regions.
In particular,
in regions \eqn{r_1} and \eqn{r_6},
it finds the closest point
in each region to the line segment \eqn{[A,CM]}
in regions \eqn{r_2} and \eqn{r_3},
it finds the closest point
in each region to the line segment \eqn{[B,CM]} and
in regions \eqn{r_4} and \eqn{r_5},
it finds the closest point
in each region to the line segment \eqn{[C,CM]}
where \eqn{CM=(A+B+C)/3} is the center of mass.

See the example for this function or example for
\code{index.six.Te} function.
If there is no data point in region \eqn{r_i},
then it returns "\code{NA} \code{NA}" for \eqn{i}-th row in the extrema.
\code{ch.all.intri} is for checking
whether all data points are in \eqn{T_e} (default is \code{FALSE}).
}
\examples{
\donttest{
n<-20  #try also n<-100
Xp<-runif.std.tri(n)$gen.points

Ext<-six.extremaTe(Xp)
Ext
summary(Ext)
plot(Ext)

sixt<-Ext

A<-c(0,0); B<-c(1,0); C<-c(0.5,sqrt(3)/2);
Te<-rbind(A,B,C)
CM<-(A+B+C)/3
D1<-(B+C)/2; D2<-(A+C)/2; D3<-(A+B)/2;
Ds<-rbind(D1,D2,D3)

h1<-c(1/2,sqrt(3)/18); h2<-c(2/3, sqrt(3)/9); h3<-c(2/3, 2*sqrt(3)/9);
h4<-c(1/2, 5*sqrt(3)/18); h5<-c(1/3, 2*sqrt(3)/9); h6<-c(1/3, sqrt(3)/9);

r1<-(h1+h6+CM)/3;r2<-(h1+h2+CM)/3;r3<-(h2+h3+CM)/3;
r4<-(h3+h4+CM)/3;r5<-(h4+h5+CM)/3;r6<-(h5+h6+CM)/3;

Xlim<-range(Te[,1],Xp[,1])
Ylim<-range(Te[,2],Xp[,2])
xd<-Xlim[2]-Xlim[1]
yd<-Ylim[2]-Ylim[1]

plot(A,pch=".",xlab="",ylab="",axes=TRUE,xlim=Xlim+xd*c(-.05,.05),
ylim=Ylim+yd*c(-.05,.05))
polygon(Te)
L<-Te; R<-Ds
segments(L[,1], L[,2], R[,1], R[,2], lty=2)
polygon(rbind(h1,h2,h3,h4,h5,h6))
points(Xp)
points(sixt$ext,pty=2,pch=4,col="red")

txt<-rbind(Te,r1,r2,r3,r4,r5,r6)
xc<-txt[,1]+c(-.02,.02,.02,0,0,0,0,0,0)
yc<-txt[,2]+c(.02,.02,.03,0,0,0,0,0,0)
txt.str<-c("A","B","C","1","2","3","4","5","6")
text(xc,yc,txt.str)
}

}
\seealso{
\code{\link{index.six.Te}} and \code{\link{cl2edges.std.tri}}
}
\author{
Elvan Ceyhan
}
