% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AuxGeometry.R
\name{is.point}
\alias{is.point}
\title{Check the argument is a point of a given dimension}
\usage{
is.point(p, dim = 2)
}
\arguments{
\item{p}{A \code{vector} to be checked
to see it is a point of dimension \code{dim} or not.}

\item{dim}{A positive integer
representing the dimension of the argument \code{p}.}
}
\value{
\code{TRUE} if \code{p} is a \code{vector} of dimension \code{dim}.
}
\description{
Returns \code{TRUE} if the argument \code{p}
is a \code{numeric} point of dimension \code{dim}
(default is \code{dim=2}); otherwise returns \code{FALSE}.
}
\examples{
\donttest{
A<-c(-1.22,-2.33); B<-c(2.55,3.75,4)
is.point(A)
is.point(A,1)

is.point(B)
is.point(B,3)
}

}
\seealso{
\code{\link{dimension}}
}
\author{
Elvan Ceyhan
}
